/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.jobs.model.Profession;

@Singleton
public class ProfessionDictionary {
    private Map<String, Profession> byName = new HashMap<String, Profession>();
    public static Profession NULL_PROFESSION = new Profession();
    public static Profession SPECIFIC_PROFESSION_REQUIRED = new Profession();

    @Inject
    public ProfessionDictionary() throws IOException {
        this(new File("assets/definitions/professions.json"));
    }

    public ProfessionDictionary(File professionsJsonFile) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List professions = (List)objectMapper.readValue(FileUtils.readFileToString(professionsJsonFile, "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, Profession.class));
        for (Profession profession : professions) {
            this.byName.put(profession.getName(), profession);
        }
    }

    public Profession getByName(String name) {
        return this.byName.get(name);
    }

    public Collection<Profession> getAll() {
        return this.byName.values();
    }

    public Profession getDefault() {
        return this.byName.get("VILLAGER");
    }

    static {
        NULL_PROFESSION.setName("Null profession");
        SPECIFIC_PROFESSION_REQUIRED.setName("Specific profession required");
    }
}

